<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-28 14:17
 */
interface ProjectexchmaterialdetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Projectexchmaterialdetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param projectexchmaterialdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Projectexchmaterialdetail projectexchmaterialdetail
 	 */
	public function insert($projectexchmaterialdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Projectexchmaterialdetail projectexchmaterialdetail
 	 */
	public function update($projectexchmaterialdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProjectexchid($value);

	public function queryByProductid($value);

	public function queryByPronumber($value);


	public function deleteByProjectexchid($value);

	public function deleteByProductid($value);

	public function deleteByPronumber($value);


}
?>